/////////////////////////////////////////////////////////////
// CINEMA SDK : BITMAP FILTER                              //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_BITMAPFILTERSTRUCT_H
#define __C4D_BITMAPFILTERSTRUCT_H

struct C4D_BitmapFilter
{
	BM_TILE*    (*BitmapTileGet       )(BM_REF bm, const RECT32 *src_rect, LONG width, LONG height, LONG tile_mode, LONG flags, LONG unused);
	LONG        (*BitmapTileDetach    )(BM_REF bm, BM_TILE *tile_buf, LONG flags);
	Bool        (*ConvertTileToBasebmp)(const BM_TILE *tile, const RECT32 *tile_rect, BaseBitmap *bmp, LONG zero);

	LONG        (*DiscardChanges      )(BM_REF bm);
	LONG        (*UpdateView          )(BM_REF bm);

	PROGRESS_ID	(*ProgressNew         )(void);
	LONG        (*ProgressDelete      )(PROGRESS_ID pid);
	LONG        (*ProgressUpdate      )(PROGRESS_ID pid, LONG current_value, LONG max_value, const String *text);

	Bool				(*GetGlobalFilterPrefs)(BaseContainer *prefs);
	Bool        (*SetGlobalFilterPrefs)(const BaseContainer *prefs);

	void*				(*GetEditorWindow     )(void);					// returns the hwnd of the editor window
	Bool				(*IsHostWindow        )(void *win);			// check if the hwnd is one of cinema windows
	Bool        (*Mac_hostProcessEvent)(void *event);		// call mac event proc, return TRUE programm should stop
};

#endif
